function [Delta_p_new,Delta_y_max_obs] = fault_slip_pressure_step(~,Delta_p_max,...
    Delta_p_min,Delta_p_old,Delta_y_target,y_prev_vec,y_tilde_unc_vec,y_tilde_unc_prev_vec,...
    y_tilde_vec,y_tilde_prev_vec,y_vec)
%
% Computes the pressure step size for plotting with variable pressure steps.
%

% Compute next step with aim to achieve Delta_y_tilde = Delta_y_tilde_target:
Delta_y_obs = max(abs(y_vec - y_prev_vec)); % maximum observed change in y_i, -
Delta_y_tilde_unc_obs = max(abs(y_tilde_unc_vec - y_tilde_unc_prev_vec)); % maximum change ...
    % in y_tilde_unc_i, -
Delta_y_tilde_obs = max(abs(y_tilde_vec - y_tilde_prev_vec)); % maximum change in y_tilde_i, -
Delta_y_min_obs = min([Delta_y_obs,Delta_y_tilde_unc_obs,Delta_y_tilde_obs]);
Delta_y_max_obs = max([Delta_y_obs,Delta_y_tilde_unc_obs,Delta_y_tilde_obs]);
if Delta_y_min_obs == 0
    Delta_p_new = Delta_p_old; % to avoid division by zero
else
% %     n = max(1,(Delta_y_max_obs/Delta_y_target)^2); % exponent to determine agressiveness of ...
% %         % pressure step udating; grows quadratically with deviation from target 
    n = 1.5; % exponent to determine agressiveness of pressure step udating;
    Delta_p_new = Delta_p_old * (Delta_y_target/Delta_y_max_obs)^n;
end

% Check step size:
if abs(Delta_p_new) > abs(Delta_p_max)
    Delta_p_new = Delta_p_max;
end
if abs(Delta_p_new) < abs(Delta_p_min)
    Delta_p_new = Delta_p_min;
end